/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.setup;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.ComposterBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.loot.functions.LootFunctionManager;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import vectorwing.farmersdelight.crafting.conditions.VanillaCrateEnabledCondition;
import vectorwing.farmersdelight.loot.functions.CopyMealFunction;
import vectorwing.farmersdelight.loot.functions.SmokerCookFunction;
import vectorwing.farmersdelight.mixin.accessors.ChickenEntityAccessor;
import vectorwing.farmersdelight.mixin.accessors.PigEntityAccessor;
import vectorwing.farmersdelight.registry.ModAdvancements;
import vectorwing.farmersdelight.registry.ModEffects;
import vectorwing.farmersdelight.registry.ModItems;
import vectorwing.farmersdelight.setup.Configuration;
import vectorwing.farmersdelight.tile.dispenser.CuttingBoardDispenseBehavior;
import vectorwing.farmersdelight.utils.tags.ModTags;
import vectorwing.farmersdelight.world.CropPatchGeneration;
import vectorwing.farmersdelight.world.VillageStructures;

@Mod.EventBusSubscriber(modid="farmersdelight")
@ParametersAreNonnullByDefault
public class CommonEventHandler {
    private static final ResourceLocation SHIPWRECK_SUPPLY_CHEST = LootTables.field_204772_t;
    private static final Set<ResourceLocation> VILLAGE_HOUSE_CHESTS = Sets.newHashSet((Object[])new ResourceLocation[]{LootTables.field_215826_q, LootTables.field_215829_t, LootTables.field_215828_s, LootTables.field_215827_r, LootTables.field_215825_p});

    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CommonEventHandler.registerCompostables();
            CommonEventHandler.registerDispenserBehaviors();
            CropPatchGeneration.registerConfiguredFeatures();
            ArrayList<ItemStack> chickenFood = new ArrayList<ItemStack>();
            Collections.addAll(chickenFood, ChickenEntityAccessor.getFoodItems().func_193365_a());
            chickenFood.add(new ItemStack((IItemProvider)ModItems.CABBAGE_SEEDS.get()));
            chickenFood.add(new ItemStack((IItemProvider)ModItems.TOMATO_SEEDS.get()));
            chickenFood.add(new ItemStack((IItemProvider)ModItems.RICE.get()));
            ChickenEntityAccessor.setFoodItems(Ingredient.func_234819_a_(chickenFood.stream()));
            ArrayList<ItemStack> pigFood = new ArrayList<ItemStack>();
            Collections.addAll(pigFood, PigEntityAccessor.getFoodItems().func_193365_a());
            pigFood.add(new ItemStack((IItemProvider)ModItems.CABBAGE.get()));
            pigFood.add(new ItemStack((IItemProvider)ModItems.TOMATO.get()));
            PigEntityAccessor.setFoodItems(Ingredient.func_234819_a_(pigFood.stream()));
        });
        ModAdvancements.register();
        LootFunctionManager.func_237451_a_((String)CopyMealFunction.ID.toString(), (ILootSerializer)new CopyMealFunction.Serializer());
        LootFunctionManager.func_237451_a_((String)SmokerCookFunction.ID.toString(), (ILootSerializer)new SmokerCookFunction.Serializer());
        CraftingHelper.register((IConditionSerializer)new VanillaCrateEnabledCondition.Serializer());
        if (((Boolean)Configuration.GENERATE_VILLAGE_COMPOST_HEAPS.get()).booleanValue()) {
            VillageStructures.init();
        }
    }

    public static void registerDispenserBehaviors() {
        if (((Boolean)Configuration.DISPENSER_TOOLS_CUTTING_BOARD.get()).booleanValue()) {
            CuttingBoardDispenseBehavior.registerBehaviour(Items.field_151039_o, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.field_151053_p, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.field_151038_n, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.field_151050_s, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.field_151049_t, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.field_151051_r, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.field_151035_b, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.field_151036_c, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.field_151037_a, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.field_151046_w, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.field_151056_x, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.field_151047_v, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.field_151005_D, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.field_151006_E, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.field_151011_C, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.field_234756_kK_, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.field_234757_kL_, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.field_234755_kJ_, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(Items.field_151097_aZ, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour((Item)ModItems.FLINT_KNIFE.get(), new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour((Item)ModItems.IRON_KNIFE.get(), new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour((Item)ModItems.DIAMOND_KNIFE.get(), new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour((Item)ModItems.GOLDEN_KNIFE.get(), new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour((Item)ModItems.NETHERITE_KNIFE.get(), new CuttingBoardDispenseBehavior());
        }
    }

    public static void registerCompostables() {
        ComposterBlock.field_220299_b.put((Object)ModItems.TREE_BARK.get(), 0.3f);
        ComposterBlock.field_220299_b.put((Object)ModItems.STRAW.get(), 0.3f);
        ComposterBlock.field_220299_b.put((Object)ModItems.CABBAGE_SEEDS.get(), 0.3f);
        ComposterBlock.field_220299_b.put((Object)ModItems.TOMATO_SEEDS.get(), 0.3f);
        ComposterBlock.field_220299_b.put((Object)ModItems.RICE.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.RICE_PANICLE.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.PUMPKIN_SLICE.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.CABBAGE_LEAF.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.CABBAGE.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.ONION.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.TOMATO.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.WILD_CABBAGES.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.WILD_ONIONS.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.WILD_TOMATOES.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.WILD_CARROTS.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.WILD_POTATOES.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.WILD_BEETROOTS.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.WILD_RICE.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.PIE_CRUST.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.RICE_BALE.get(), 0.85f);
        ComposterBlock.field_220299_b.put((Object)ModItems.SWEET_BERRY_COOKIE.get(), 0.85f);
        ComposterBlock.field_220299_b.put((Object)ModItems.HONEY_COOKIE.get(), 0.85f);
        ComposterBlock.field_220299_b.put((Object)ModItems.CAKE_SLICE.get(), 0.85f);
        ComposterBlock.field_220299_b.put((Object)ModItems.APPLE_PIE_SLICE.get(), 0.85f);
        ComposterBlock.field_220299_b.put((Object)ModItems.SWEET_BERRY_CHEESECAKE_SLICE.get(), 0.85f);
        ComposterBlock.field_220299_b.put((Object)ModItems.CHOCOLATE_PIE_SLICE.get(), 0.85f);
        ComposterBlock.field_220299_b.put((Object)ModItems.RAW_PASTA.get(), 0.85f);
        ComposterBlock.field_220299_b.put((Object)ModItems.APPLE_PIE.get(), 1.0f);
        ComposterBlock.field_220299_b.put((Object)ModItems.SWEET_BERRY_CHEESECAKE.get(), 1.0f);
        ComposterBlock.field_220299_b.put((Object)ModItems.CHOCOLATE_PIE.get(), 1.0f);
        ComposterBlock.field_220299_b.put((Object)ModItems.DUMPLINGS.get(), 1.0f);
        ComposterBlock.field_220299_b.put((Object)ModItems.STUFFED_PUMPKIN.get(), 1.0f);
        ComposterBlock.field_220299_b.put((Object)ModItems.BROWN_MUSHROOM_COLONY.get(), 1.0f);
        ComposterBlock.field_220299_b.put((Object)ModItems.RED_MUSHROOM_COLONY.get(), 1.0f);
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder builder = event.getGeneration();
        Biome.Climate climate = event.getClimate();
        if (event.getName().func_110623_a().equals("beach")) {
            if (((Boolean)Configuration.GENERATE_WILD_BEETROOTS.get()).booleanValue()) {
                builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, CropPatchGeneration.PATCH_WILD_BEETROOTS);
            }
            if (((Boolean)Configuration.GENERATE_WILD_CABBAGES.get()).booleanValue()) {
                builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, CropPatchGeneration.PATCH_WILD_CABBAGES);
            }
        }
        if ((event.getCategory().equals((Object)Biome.Category.SWAMP) || event.getCategory().equals((Object)Biome.Category.JUNGLE)) && ((Boolean)Configuration.GENERATE_WILD_RICE.get()).booleanValue()) {
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, CropPatchGeneration.PATCH_WILD_RICE);
        }
        if (climate.field_242461_c >= 1.0f && ((Boolean)Configuration.GENERATE_WILD_TOMATOES.get()).booleanValue()) {
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, CropPatchGeneration.PATCH_WILD_TOMATOES);
        }
        if (climate.field_242461_c > 0.3f && climate.field_242461_c < 1.0f) {
            if (((Boolean)Configuration.GENERATE_WILD_CARROTS.get()).booleanValue()) {
                builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, CropPatchGeneration.PATCH_WILD_CARROTS);
            }
            if (((Boolean)Configuration.GENERATE_WILD_ONIONS.get()).booleanValue()) {
                builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, CropPatchGeneration.PATCH_WILD_ONIONS);
            }
        }
        if (climate.field_242461_c > 0.0f && climate.field_242461_c <= 0.3f && ((Boolean)Configuration.GENERATE_WILD_POTATOES.get()).booleanValue()) {
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, CropPatchGeneration.PATCH_WILD_POTATOES);
        }
    }

    @SubscribeEvent
    public static void onVillagerTrades(VillagerTradesEvent event) {
        if (!((Boolean)Configuration.FARMERS_BUY_FD_CROPS.get()).booleanValue()) {
            return;
        }
        Int2ObjectMap trades = event.getTrades();
        VillagerProfession profession = event.getType();
        if (profession.getRegistryName() == null) {
            return;
        }
        if (profession.getRegistryName().func_110623_a().equals("farmer")) {
            ((List)trades.get(1)).add(new EmeraldForItemsTrade((IItemProvider)ModItems.ONION.get(), 26, 16, 2));
            ((List)trades.get(1)).add(new EmeraldForItemsTrade((IItemProvider)ModItems.TOMATO.get(), 26, 16, 2));
            ((List)trades.get(2)).add(new EmeraldForItemsTrade((IItemProvider)ModItems.CABBAGE.get(), 16, 16, 5));
            ((List)trades.get(2)).add(new EmeraldForItemsTrade((IItemProvider)ModItems.RICE.get(), 20, 16, 5));
        }
    }

    @SubscribeEvent
    public static void handleAdditionalFoodEffects(LivingEntityUseItemEvent.Finish event) {
        Item food = event.getItem().func_77973_b();
        LivingEntity entity = event.getEntityLiving();
        if (((Boolean)Configuration.RABBIT_STEW_JUMP_BOOST.get()).booleanValue() && food.equals(Items.field_179560_bq)) {
            entity.func_195064_c(new EffectInstance(Effects.field_76430_j, 3600, 1));
        }
        if (((Boolean)Configuration.COMFORT_FOOD_TAG_EFFECT.get()).booleanValue() && food.func_206844_a(ModTags.COMFORT_FOODS)) {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.COMFORT.get(), 6000, 0));
        }
    }

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent event) {
        if (((Boolean)Configuration.CROPS_ON_SHIPWRECKS.get()).booleanValue() && event.getName().equals((Object)SHIPWRECK_SUPPLY_CHEST)) {
            event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("farmersdelight", "inject/shipwreck_supply")).func_216086_a(1).func_216085_b(0)).name("supply_fd_crops").func_216044_b());
        }
        if (((Boolean)Configuration.CROPS_ON_VILLAGE_HOUSES.get()).booleanValue() && VILLAGE_HOUSE_CHESTS.contains(event.getName())) {
            event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("farmersdelight", "inject/crops_villager_houses")).func_216086_a(1).func_216085_b(0)).name("villager_houses_fd_crops").func_216044_b());
        }
    }

    static class EmeraldForItemsTrade
    implements VillagerTrades.ITrade {
        private final Item tradeItem;
        private final int count;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public EmeraldForItemsTrade(IItemProvider tradeItemIn, int countIn, int maxUsesIn, int xpValueIn) {
            this.tradeItem = tradeItemIn.func_199767_j();
            this.count = countIn;
            this.maxUses = maxUsesIn;
            this.xpValue = xpValueIn;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            ItemStack itemstack = new ItemStack((IItemProvider)this.tradeItem, this.count);
            return new MerchantOffer(itemstack, new ItemStack((IItemProvider)Items.field_151166_bC), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }
}

